/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.atmSW.AtmView;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.ChassisLike;
import ibm.nways.jdm8285.DeviceView.ChassisUnknown;
import ibm.nways.jdm8285.DeviceView.LateStatusLike;
import ibm.nways.jdm8285.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8285.DeviceView.StatusAttachInfo;
import ibm.nways.jdm8285.DeviceView.StatusRefLike;
import ibm.nways.launcher.LaunchContext;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Chassis
implements ChassisLike,
ChassisInfoLike {
    public static final String SYSOID_8285 = "1.3.6.1.4.1.2.6.33.2.2";
    private String chassisIp = "0.0.0.0";
    private final Vector components = new Vector();
    private GraphicPanel graphicPanel;
    private GraphicPanel atmView;
    protected JdmBrowser jdmBrowser;
    protected GenModel atmSWInterfaceModel;
    protected GenModel atmSWModel;
    protected GenModel viewModel;
    private Vector launchableItems = new Vector();
    protected GraphicContainer container;
    protected ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8285.DeviceView.GraphicResources");
    protected StatusAttachThread statusThread;
    protected int slot = 1;
    protected ChassisInfoLike chassisInfo;
    protected int modType;
    protected GenModel portsModel;
    protected Vector stack = new Vector();
    protected Vector lateStack = new Vector();

    public void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public void setCommonInformation(JdmBrowser jdmBrowser, GenModel genModel, ChassisInfoLike chassisInfoLike, GraphicContainer graphicContainer) {
        String string = "setCommonInformation (Chassis)";
        this.jdmBrowser = jdmBrowser;
        this.modType = 6;
        this.container = graphicContainer;
        this.chassisInfo = chassisInfoLike;
        try {
            this.portsModel = (GenModel)genModel.getComponent("AtmSWInterface");
            SnmpContextModel snmpContextModel = (SnmpContextModel)((GenModel)this.jdmBrowser.getModel()).getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            this.chassisIp = (String)((Object)modelInfo.get("Config.Address"));
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
            return;
        }
    }

    public void askStatus(GenModel genModel, GraphicImage graphicImage, ModelInfo modelInfo, LeafCompositeLike leafCompositeLike) {
        this.stack.addElement(new StatusAttachInfo(genModel, graphicImage, modelInfo, leafCompositeLike));
    }

    public void askStatus(LateStatusLike lateStatusLike) {
        this.lateStack.addElement(lateStatusLike);
    }

    public void draw() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
    }

    public GraphicPanel getGraphicPanel() {
        String string = "getGraphicPanel (Chassis)";
        if (this instanceof ChassisUnknown) {
            return null;
        }
        try {
            this.atmSWModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("AtmSW");
            if (this.atmSWModel != null) {
                this.viewModel = (GenModel)this.atmSWModel.getComponent("AtmView");
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
        }
        if (this.graphicPanel == null) {
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
        }
        return this.graphicPanel;
    }

    public String getFlyOver(String string) {
        Object[] objectArray = new Object[]{this.chassisIp};
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.jdm8285.DeviceView.GraphicResources", string, objectArray);
        return i18NMsgFormat.getTranslation();
    }

    public JdmBrowser getBrowser() {
        return this.jdmBrowser;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void dispose() {
        String string = "dispose (Chassis)";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        if (this.statusThread != null) {
            this.statusThread.interrupt();
            this.statusThread = null;
        }
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.stack.removeAllElements();
        this.lateStack.removeAllElements();
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        this.jdmBrowser = null;
        this.bundle = null;
        this.portsModel = null;
        this.atmSWInterfaceModel = null;
        this.atmSWModel = null;
        this.viewModel = null;
        this.components.removeAllElements();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public void startThreads() {
        this.stopThreads();
        this.statusThread = new StatusAttachThread();
        this.statusThread.setName("Status Attach");
        this.statusThread.start();
    }

    public void stopThreads() {
        if (this.statusThread != null) {
            this.statusThread.interrupt();
            this.stack.removeAllElements();
            this.lateStack.removeAllElements();
            this.statusThread = null;
        }
    }

    public int getNumberOfLaunchableItems() {
        return this.launchableItems.size();
    }

    public void addLaunchContext(NavigationContext navigationContext) {
        if (!this.launchableItems.isEmpty()) {
            navigationContext.put((Object)"launcherFolderContext", (Object)this.launchableItems);
        }
    }

    public void addLaunchableItem(String string, String string2, int n) {
        if (string2 != null && !string2.equals("0.0.0.0")) {
            LaunchContext launchContext = new LaunchContext();
            launchContext.setSlotNumber(string, Integer.toString(n));
            launchContext.setIpAddress(string, string2);
            Object[] objectArray = new Object[]{launchContext.getName(string), new Integer(n)};
            I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.jdm8285.DeviceView.GraphicResources", "LaunchTitle", objectArray);
            launchContext.setNavTitle(string, i18NMsgFormat.getTranslation());
            this.launchableItems.addElement(launchContext.getProp(string));
        }
    }

    public GenModel getAtmSWInterfaceModel() {
        block2: {
            String string = "getAtmSWInterfaceModel";
            if (this.atmSWInterfaceModel != null) break block2;
            try {
                this.atmSWInterfaceModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("AtmSWInterface");
            }
            catch (Exception exception) {
                RAS.logException(19, 6, this, string, exception);
            }
        }
        return this.atmSWInterfaceModel;
    }

    public void switchToDeviceView() {
        this.jdmBrowser.setGraphicPanel(this.graphicPanel);
    }

    public void switchToAtmView() {
        if (this.atmView == null) {
            AtmView atmView = new AtmView((BrowserApplet)this.jdmBrowser, this.viewModel, this.getAtmSWInterfaceModel());
            this.atmView = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)atmView);
        }
        this.jdmBrowser.setGraphicPanel(this.atmView);
    }

    public abstract void discoverChildren();

    private class StatusAttachThread
    extends Thread {
        public void run() {
            Object object;
            int n;
            String string = "run";
            if (RAS.isEnabled(19, 6)) {
                RAS.enter(19, 6, this, string);
                RAS.trace(19, 6, this, string, "Status thread running...");
            }
            Vector vector = Chassis.this.stack;
            synchronized (vector) {
                n = 0;
                while (n < Chassis.this.stack.size()) {
                    if (this.isInterrupted()) break;
                    try {
                        object = (StatusAttachInfo)Chassis.this.stack.elementAt(n);
                        RemoteStatus remoteStatus = null;
                        remoteStatus = ((StatusAttachInfo)object).info != null ? ((StatusAttachInfo)object).model.getStatusRefForRow(((StatusAttachInfo)object).info) : ((StatusAttachInfo)object).model.getStatus("default");
                        StatusProxy statusProxy = new StatusProxy(remoteStatus);
                        if (((StatusAttachInfo)object).image != null) {
                            ((StatusAttachInfo)object).image.setStatus((Status)statusProxy);
                        }
                        if (((StatusAttachInfo)object).object instanceof StatusRefLike) {
                            ((StatusRefLike)((Object)((StatusAttachInfo)object).object)).setStatusRef(statusProxy);
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 6, this, string, exception);
                    }
                    ++n;
                }
            }
            Chassis.this.stack.removeAllElements();
            vector = Chassis.this.lateStack;
            synchronized (vector) {
                try {
                    n = 0;
                    while (n < Chassis.this.lateStack.size()) {
                        if (!this.isInterrupted()) {
                            object = (LateStatusLike)Chassis.this.lateStack.elementAt(n);
                            object.statusesAttached();
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 6, this, string, exception);
                }
            }
            Chassis.this.lateStack.removeAllElements();
            if (RAS.isEnabled(19, 6)) {
                RAS.exit(19, 6, this, string);
                RAS.trace(19, 6, this, string, "End of status thread.");
            }
        }

        StatusAttachThread() {
            Chassis.this = Chassis.this;
        }
    }
}

